/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.mixin;

import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.regions_unexplored.block.RegionsUnexploredBlocks;
import net.regions_unexplored.util.worldgen.TrunkPlacerDirtUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TrunkPlacer.class})
public abstract class TrunkPlacerDirtMixin {
    @Inject(at={@At(value="HEAD")}, method={"setDirtAt(Lnet/minecraft/world/level/LevelSimulatedReader;Ljava/util/function/BiConsumer;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/feature/configurations/TreeConfiguration;)V"}, cancellable=true)
    private static void setDirtAt(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> dirt, RandomSource random, BlockPos pos, TreeConfiguration configuration, CallbackInfo ci) {
        if (!((LevelReader)level).m_8055_(pos).onTreeGrow((LevelReader)level, dirt, random, pos, configuration) && TrunkPlacerDirtUtil.isForestGrass(level, pos)) {
            dirt.accept(pos, ((Block)RegionsUnexploredBlocks.FOREST_DIRT.get()).m_49966_());
        }
        if (!((LevelReader)level).m_8055_(pos).onTreeGrow((LevelReader)level, dirt, random, pos, configuration) && TrunkPlacerDirtUtil.isPlainsGrass(level, pos)) {
            dirt.accept(pos, ((Block)RegionsUnexploredBlocks.PLAINS_DIRT.get()).m_49966_());
        }
        if (!((LevelReader)level).m_8055_(pos).onTreeGrow((LevelReader)level, dirt, random, pos, configuration) && TrunkPlacerDirtUtil.isAlphaGrass(level, pos)) {
            dirt.accept(pos, Blocks.f_50493_.m_49966_());
        }
    }
}

